<?php
function getNewsList($limit)
{
  if(!$this->dbo){
    return 'Lista newsów nie jest dostępna.';
  }
  
  //Odczytanie parametru page.
  if(isset($_GET['page'])){
    $page = intval($_GET['page']);
  }
  else{
    $page = 0;
  }
  
  //Określenie całkowitej liczby wierszy w tabeli News.
  $query = "SELECT COUNT(*) FROM News";
  $rowsCount = intval($this->dbo->getQuerySingleResult($query));
  
  //Obliczenie całkowitej liczby stron z wynikami.
  if($limit != 0){
    $pages = ceil($rowsCount / $limit);  
    if($page < 0 || $page >= $pages){
      $page = 0;
    }
    $offset = $page * $limit;
  }
  else{
    $page = 0;
    $pages = 1;
    $offset = 0;
    $limit = $rowsCount;
  }
  
  //Zapytanie pobierające wyniki dla bieżącej strony.
  $query = "SELECT n.Id, n.Naglowek, n.Data, u.Nazwa ";
  $query .= "FROM News n INNER JOIN Users u ";
  $query .= "ON n.UserId = u.Id ";
  $query .= "ORDER BY Data DESC ";
  $query .= "LIMIT $offset, $limit";
  
  if(!$result = $this->dbo->query($query)){
    echo 'Błąd serwera. Brak listy news.';
  }
  
  //Formowanie wyników.
  $str = '<div id="newsListDiv">';
  $str .= '<table><tr>';
  $str .= '<th>Nagłówek</th><th>Data</th><th>Autor</th>';
  $str .= '</tr>';

  //Odczyt wyników zapytania.
  while($row = $result->fetch_row()){
    $str .= '<tr>';
    $str .=  '<td><a href="index.php?action=showNews&amp;newsId='.
       $row[0].'">'.$row[1].'</a></td>';
    $str .= '<td>'.$row[2].'</td>';
    $str .= '<td>'.$row[3].'</td>';
    $str .= '</tr>';
  }
  $str .= '</table>';

  //Uzyskanie paginacji.
  $str .= '<div id="paginationDiv">';
  $str .= $this->dbo->getPagination($page, $pages, 
                    'index.php?action=showNewsList',
                    'Idź do strony: ');
  $str .= '</div></div>';
  
  return $str;
}
?>